//
//  COTables.h
//  GSFontTools
//
//  Created by Georg Seifert on 10.08.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

//@class MGOrderedDictionary;

@class COBaseLookupList;
@class COBaseLookup;
@class BaseTTXConverter;
@class COGlyphClassDef;
//@class COAttachList;
@class COMarkAttachClassDef;
@class OTAttachPoint;
@class OTLigCaretList;
@class OTLigGlyph;
@class OTCaretValue;
@class OTGDEF;
@class OTAttachList;
@class COCoverage;
@class OTScriptList;
@class OTFeatureList;

@interface COBaseTable : NSObject {
	OTScriptList *_scriptList;
	OTFeatureList *_featureList;
	COBaseLookupList *_lookupList;
	NSMutableDictionary *_cmap;
	NSMutableDictionary *_applicableFeatureCache;
	NSMutableArray *_featureTags;
	NSMutableDictionary *_featureApplicationStates;
}
@property (nonatomic, retain) OTScriptList *scriptList;
@property (nonatomic, retain) OTFeatureList *featureList;
@property (nonatomic, retain) COBaseLookupList *lookupList;

- (id)initFromFontToolsWithTable:(BaseTTXConverter *)table reversedCMAP:(NSMutableDictionary *)reversedCMAP gdef:(OTGDEF *)gdef;
- (NSArray *)featuresAtIndexes:(NSIndexSet *)featuresIndexes;
- (NSArray *)process:(NSArray *)glyphRecords script:(NSString *)theScriptTag langSys:(NSString *)theLangSysTag;
- (NSArray *)_processLookupsWithGlyphRecords:(NSMutableArray *)glyphRecords lookups:(NSArray *)lookups processingAalt:(BOOL)processingAalt;
- (BOOL)_processLookupWithProcessed:(NSMutableArray *)processed glyphRecords:(NSMutableArray *)glyphRecords lookup:(COBaseLookup *)theLookup featureTag:(NSString *)featureTag;
- (Class)lookupListClass;
- (void)resetFeatureStates;
- (BOOL)featureState:(NSString *)featureTag;
- (void)setFeatureState:(BOOL)state forTag:(NSString *)featureTag;
- (BOOL)containsFeatureTag:(NSString *)featureTag;
- (NSArray *)languageList;
- (NSArray *)featureTags;
@end

@interface COGSUB : COBaseTable {}
// class GSUB(BaseTable):
@end

@interface COGPOS : COBaseTable {}
// class GPOS(BaseTable):
@end

@interface COLigGlyph : NSObject
// class LigGlyph(object):

/*
 Deviation from spec:
 - CaretValueCount attribute is not implemented.
 */
{
	//__slots__ = ["CaretValue"]
	NSMutableArray *_caretValues;
}

- (id)initFromFontToolsWithLigGlyph:(OTLigGlyph *)theLigGlyph;
@end

@interface COCaretValueFormat1 : NSObject
// class CaretValueFormat1(object):
{
	//__slots__ = ["CaretValueFormat", "Coordinate"]
	NSUInteger _caretValueFormat;
	NSUInteger _coordinate;
}

- (id)initFromFontToolsWithCaretValue:(OTCaretValue *)theCaretValue;
@end

@interface COCaretValueFormat2 : NSObject
// class CaretValueFormat1(object):
{
	//__slots__ = ["CaretValueFormat", "Coordinate"]
	NSUInteger _caretValueFormat;
	NSUInteger _caretValuePoint;
}

- (id)initFromFontToolsWithCaretValue:(OTCaretValue *)theCaretValue;
@end

@interface COCaretValueFormat3 : COCaretValueFormat1
// class CaretValueFormat1(object):
{
	//__slots__ = ["CaretValueFormat", "Coordinate"]
	id _deviceTable;
}
@end
